% This script gives a minimalistic example how to evaluate a single
% trajectory obtaind from the dataset, regardless if based on the plenoptic
% of stereo sequence.
%
% To use this code the trajectory should be stored in the following format:
%
% frameId timeStamp tx ty tz qx qy qz qw
%
% Here [tx ty tz] defines the translation vector and [qx qy qz qw] the
% rotation as unit quaternion from camera to world coordinates
%
% For the evaluation timeStamp and the unit quaternion are not necesarly
% have to be correct.

fileGt = 'data_example/example_gt_data.txt';
fileTrajectory = 'data_example/example_trajectory.txt';

groundTruth =readTrajectoryData( fileGt );
trajectory =readTrajectoryData( fileTrajectory );

[ absS,errS,errR,errAlign,rmse_f,rmse_b ] = calcDrift( groundTruth, trajectory );


