function [ absS,errS,errR,errAlign,rmse_f,rmse_b ] = calcDrift( groundTruth, trajectory )

[~,idxSplit] = max(diff(groundTruth.timeStamps));

framesGtFront = groundTruth.frames(1:idxSplit);
framesGtBack = groundTruth.frames(idxSplit+1:end);

poseGtFront = groundTruth.poseData(1:idxSplit,:);
poseGtBack = groundTruth.poseData(idxSplit+1:end,:);


idxFront = arrayfun(@(x) ~isempty(find(x==framesGtFront, 1)), trajectory.frames);
idxBack= arrayfun(@(x) ~isempty(find(x==framesGtBack, 1)), trajectory.frames);

framesFront = trajectory.frames(idxFront);
framesBack = trajectory.frames(idxBack);

poseFront = trajectory.poseData(idxFront,:);
poseBack = trajectory.poseData(idxBack,:);

idxGtFront = arrayfun(@(x) ~isempty(find(x==framesFront, 1)), framesGtFront);
idxGtBack= arrayfun(@(x) ~isempty(find(x==framesBack, 1)), framesGtBack);

poseGtFront = poseGtFront(idxGtFront,:);
poseGtBack = poseGtBack(idxGtBack,:);

gtPosFront = poseGtFront(:,1:3);
gtPosBack = poseGtBack(:,1:3);

posFront = poseFront(:,1:3);
posBack = poseBack(:,1:3);

[ rmse_f, R_f, t_f, scale_f ] = AlignSimEfficient( gtPosFront, posFront );
[ rmse_b, R_b, t_b, scale_b ] = AlignSimEfficient( gtPosBack, posBack );

T_f = [scale_f*R_f, t_f; 0 0 0 1];
T_b = [scale_b*R_b, t_b; 0 0 0 1];
T = T_f^(-1)*T_b;
R = T(1:3,1:3)/(det(T(1:3,1:3))^(1/3));

posFrontAligned = trajectory.poseData(:,1:3);
posFrontAligned = scale_f*posFrontAligned*R_f'+repmat(t_f', size(posFrontAligned,1), 1);

posBackAligned = trajectory.poseData(:,1:3);
posBackAligned = scale_b*posBackAligned*R_b'+repmat(t_b', size(posBackAligned,1), 1);

errS = max([scale_f/scale_b scale_b/scale_f]);
absS = sqrt(scale_f*scale_b);
absS = max([absS 1/absS]);
w = acos((trace(R)-1)/2);
errR = w*180/pi;

errAlign = (sum(sum((posFrontAligned-posBackAligned).^2)) / size(posFrontAligned,1))^0.5;

fprintf('%s: absScale = %8.3f   errScale = %8.3f   errRot = %8.3f   errAlign = %8.3f   rmsF = %6.1f   rmsB = %6.1f\n',cell2mat(trajectory.seqName),absS,errS,errR,errAlign,rmse_f*1000,rmse_b*1000)

end

