function trajectory = readTrajectoryData( pathTrajectoryData )

if(~exist(pathTrajectoryData,'file'))
    error('given trajectory file doe not exist')
end

trajectory = struct('seqName',[],'frames',[],'timeStamps',[],'poseData',[]);
[path,~,~] = fileparts(pathTrajectoryData);
trajectory.seqName = getfield(fliplr(strsplit(path,filesep)),{1});

f_gt = fopen(pathTrajectoryData);
data = textscan(f_gt,'%f %f %f %f %f %f %f %f %f');
trajectory.frames = data{1};
trajectory.timeStamps = data{2};
trajectory.poseData = [data{3:end}];

end

